// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents access to global variable (i.e. `$foo`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Gvar {
    /// Name of the global variable, `String("$foo")` for `$foo`
    pub name: String,

    /// Location of the full expression
    ///
    /// ```text
    /// $foo
    /// ~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Gvar {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "gvar"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.expression_l.print("expression");
    }
}
