// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a special empty else that is a part of the pattern matching.
///
/// Usually empty else (e.g. part of the `if` statement) doesn't mean anything,
/// however in pattern matching it prevents raising a `NoPatternError`.
///
/// Throwing away this `else` may affect your code.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct EmptyElse {
    /// Location of the `else` keyword
    ///
    /// ```text
    /// case foo; in 1; else; end
    ///                 ~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for EmptyElse {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "empty_else"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}
