// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a singleton method definition (i.e. `def self.foo; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Defs {
    /// Definee of a method definition, `Lvar("x")` for `def x.foo; end`
    pub definee: Box<Node>,

    /// Name of the method, `String("foo")` for `def x.foo; end`
    pub name: String,

    /// Arguments of a method, `None` if there's no arguments.
    ///
    /// All information about parentheses around arguments is stored in this node.
    pub args: Option<Box<Node>>,

    /// Body of the method, `None` if there's no body.
    pub body: Option<Box<Node>>,

    /// Location of the `def` keyword
    ///
    /// ```text
    /// def self.foo; end
    /// ~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `.`
    ///
    /// ```text
    /// def self.foo; end
    ///         ~
    /// ```
    pub operator_l: Loc,

    /// Location of the method name
    ///
    /// ```text
    /// def self.foo; end
    ///          ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `=` operator for endless method definition
    ///
    /// ```text
    /// def self.foo() = 42
    ///                ~
    /// ```
    ///
    /// `None` for regular method definition
    pub assignment_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// def self.foo; end
    ///               ~~~
    /// ```
    ///
    /// `None` for endless method definition
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// def self.foo; end
    /// ~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Defs {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.definee);
        result.push_str(&self.name);
        result.push_maybe_node_or_nil(&self.args);
        result.push_maybe_node_or_nil(&self.body);






        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "defs"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.definee.inner_ref().print_with_locs();

        if let Some(node) = self.args.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        self.operator_l.print("operator");
        self.name_l.print("name");
        if let Some(loc) = self.assignment_l.as_ref() { loc.print("assignment") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        self.expression_l.print("expression");
    }
}
