// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `defined?(foo)` expression
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Defined {
    /// Value given to `defined?`
    pub value: Box<Node>,

    /// Location of the `defined?` keyword
    ///
    /// ```text
    /// defined?(foo)
    /// ~~~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// defined?(foo)
    ///         ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// defined?(foo)
    ///             ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// defined?(foo)
    /// ~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Defined {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.value);




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "defined?"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.value.inner_ref().print_with_locs();
        self.keyword_l.print("keyword");
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        self.expression_l.print("expression");
    }
}
