// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents class variable assignment (i.e. `@@var = 42`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Cvasgn {
    /// Name of the class variable, `String("@@foo")` for `@@foo = 1`
    pub name: String,

    /// Value that is assigned to class variable, `Int("1")` for `@@foo = 1`
    pub value: Option<Box<Node>>,

    /// Location of the class variable name
    ///
    /// ```text
    /// @@foo = 1
    /// ~~~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `=` operator
    ///
    /// ```text
    /// @@foo = 1
    ///       ~
    /// ```
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// @@foo = 1
    /// ~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Cvasgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);
        result.push_maybe_node(&self.value);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "cvasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        if let Some(node) = self.value.as_ref() { node.inner_ref().print_with_locs() }
        self.name_l.print("name");
        if let Some(loc) = self.operator_l.as_ref() { loc.print("operator") }
        self.expression_l.print("expression");
    }
}
