// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a class definition (using a `class` keyword, `Class.new` is just a method call)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Class {
    /// Name of the class, `String("Foo")` for `class Foo; end`
    pub name: Box<Node>,

    /// Superclass. Can be an expression in cases like `class A < (obj.foo + 1); end`
    ///
    /// `None` if no explicit superclass given (i.e. `class Foo; end`)
    pub superclass: Option<Box<Node>>,

    /// Body of the method, `None` if there's no body.
    pub body: Option<Box<Node>>,

    /// Location of the `class` keyword.
    ///
    /// ```text
    /// class Foo; end
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `<` operator
    ///
    /// ```text
    /// class A < B; end
    ///         ~
    /// ```
    ///
    /// `None` if there's no explicit superclass given.
    pub operator_l: Option<Loc>,

    /// Location of the `end` keyword.
    ///
    /// ```text
    /// class Foo; end
    ///            ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// class Foo; end
    /// ~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Class {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.name);
        result.push_maybe_node_or_nil(&self.superclass);
        result.push_maybe_node_or_nil(&self.body);




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "class"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.name.inner_ref().print_with_locs();
        if let Some(node) = self.superclass.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.body.as_ref() { node.inner_ref().print_with_locs() }
        self.keyword_l.print("keyword");
        if let Some(loc) = self.operator_l.as_ref() { loc.print("operator") }
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
