// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a constant assignment (i.e. `A = 1`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Casgn {
    /// Scope where the constant is defined:
    /// 1. `Some(Const("A"))` for `A::B = 1`
    /// 2. `None` if it's defined in the current scope (i.e. `A = 1`)
    /// 3. `Some(Cbase)` if it's defined in the global scope (i.e. `::A = 1`)
    pub scope: Option<Box<Node>>,

    /// Name of the constant, `String("A")` for `A = 1`
    pub name: String,

    /// Value that is assigned to a constant, `Int("1")` for `A = 1`.
    ///
    /// **Note**: `None` if constant assignment is a part of the multi-assignment.
    /// In such case `value` belongs to `Masgn` node of the multi-assignment.
    pub value: Option<Box<Node>>,

    /// Location of the `::` operator
    ///
    /// ```text
    /// A::B = 1
    ///  ~~
    ///
    /// ::A = 1
    /// ~~
    /// ```
    ///
    /// `None` if the constant is defined in the current scope
    pub double_colon_l: Option<Loc>,

    /// Location of the constant name
    ///
    /// ```text
    /// A::CONST = 1
    ///    ~~~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `=` operator
    ///
    /// ```text
    /// A = 1
    ///   ~
    /// ```
    ///
    /// `None` if constant assignment is a part of the multi-assignment.
    /// In such case `=` belongs to a `Masgn` node
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// A = 1
    /// ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Casgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.scope);
        result.push_str(&self.name);
        result.push_maybe_node(&self.value);




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "casgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.scope.as_ref() { node.inner_ref().print_with_locs() }

        if let Some(node) = self.value.as_ref() { node.inner_ref().print_with_locs() }
        if let Some(loc) = self.double_colon_l.as_ref() { loc.print("double_colon") }
        self.name_l.print("name");
        if let Some(loc) = self.operator_l.as_ref() { loc.print("operator") }
        self.expression_l.print("expression");
    }
}
