// This file is auto-generated by codegen/rust/nodes/node_file.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents compound statement (i.e. a multi-statement)
///
/// Basically all blocks of code are wrapped into `Begin` node (e.g. method/block body, rescue/ensure handler etc)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Begin {
    /// A list of statements
    pub statements: Vec<Node>,

    /// Begin of the block
    ///
    /// ```text
    /// (1; 2)
    /// ~
    /// ```
    ///
    /// `None` if the block of code is "implicit", like
    ///
    /// ```text
    /// if true; 1; 2; end
    /// ```
    pub begin_l: Option<Loc>,

    /// End of the block
    ///
    /// ```text
    /// (1; 2)
    ///      ~
    /// ```
    ///
    /// `None` if the block of code is "implicit", like
    ///
    /// ```text
    /// if true; 1; 2; end
    /// ```
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// (1; 2)
    /// ~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl InnerNode for Begin {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.statements);



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "begin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.statements.iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.begin_l.as_ref() { loc.print("begin") }
        if let Some(loc) = self.end_l.as_ref() { loc.print("end") }
        self.expression_l.print("expression");
    }
}
