use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

use crate::nodes::InnerNode;
use crate::nodes::*;

/// Generic combination of all known nodes.
#[allow(missing_docs)]
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub enum Node {
{{ each node }}<dnl>
    {{ helper node-camelcase-name }}({{ helper node-camelcase-name }}),
{{ end }}<dnl>
}

impl Node {
    pub(crate) fn inner_ref(&self) -> &dyn InnerNode {
        match &self {
{{ each node }}<dnl>
            Node::{{ helper node-camelcase-name }}(inner) => inner,
{{ end }}<dnl>
        }
    }
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/nodes/node_enum.rs", contents).unwrap();
}
