// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an executable string (i.e. `` `sh #{script_name}` ``)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Xstr {
    /// A list of string parts (static literals and interpolated expressions)
    pub parts: Vec<Node>,

    /// Location of the string begin
    ///
    /// ```text
    /// `#{foo}`
    /// ~
    ///
    /// %X{#{foo}}
    /// ~~~
    /// ```
    pub begin_l: Loc,

    /// Location of the string end
    ///
    /// ```text
    /// `#{foo}`
    ///        ~
    ///
    /// %X{#{foo}}
    ///          ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// `#{foo}`
    /// ~~~~~~~~
    ///
    /// %X{#{foo}}
    /// ~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Xstr {
    #[doc(hidden)]
    pub fn get_parts(&self) -> &Vec<Node> {
        &self.parts
    }

    #[doc(hidden)]
    pub fn get_parts_mut(&mut self) -> &mut Vec<Node> {
        &mut self.parts
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_parts(&mut self, value: Vec<Node>) {
        self.parts = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalXstr {
        let Self { parts, begin_l, end_l, expression_l } = self;
        super::InternalXstr { parts, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Xstr {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.parts);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "xstr"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.parts.iter() {
          node.inner_ref().print_with_locs();
        }
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
