// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalList as List;

use super::internal::InternalXstr;
use crate::blobs::{HasBlob, Blob};

/// Represents an executable string (i.e. `` `sh #{script_name}` ``)
#[repr(C)]
pub struct Xstr {
    pub(crate) blob: Blob<Xstr>
}

impl std::fmt::Debug for Xstr {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Xstr")
            .field("parts", &self.get_parts())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Xstr {
    fn eq(&self, other: &Self) -> bool {
        self.get_parts() == other.get_parts()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Xstr {
    /// Returns `parts` field
    pub fn get_parts(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__xstr__get_parts(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `parts` field
    pub fn set_parts(&mut self, parts: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__xstr__set_parts(&mut self.blob, parts.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__xstr__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__xstr__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__xstr__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__xstr__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__xstr__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__xstr__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalXstr {
        unsafe { lib_ruby_parser__external__nodes__xstr__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__xstr__get_parts(blob: *const Blob<Xstr>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__xstr__set_parts(blob: *mut Blob<Xstr>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__xstr__get_begin_l(blob: *const Blob<Xstr>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__xstr__set_begin_l(blob: *mut Blob<Xstr>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__xstr__get_end_l(blob: *const Blob<Xstr>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__xstr__set_end_l(blob: *mut Blob<Xstr>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__xstr__get_expression_l(blob: *const Blob<Xstr>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__xstr__set_expression_l(blob: *mut Blob<Xstr>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__xstr__into_internal(blob: Blob<Xstr>) -> InternalXstr;
    fn lib_ruby_parser__external__nodes__xstr__drop(blob: *mut Blob<Xstr>);
}

impl InnerNode for Xstr {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_parts());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "xstr"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_parts().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Xstr {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__xstr__drop(&mut self.blob) }
    }
}
