// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a branch of the `case` statement (i.e. `when foo`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct When {
    /// A list of values to compare/match against
    pub patterns: Vec<Node>,

    /// Body of the `when` branch
    pub body: Option<Box<Node>>,

    /// Location of the `when` keyword
    ///
    /// ```text
    /// case foo; when bar; end
    ///           ~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// case foo; when bar then baz; end
    ///                    ~~~~
    /// ```
    ///
    /// `then` is optional, and so `begin_l` can be `None`
    pub begin_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; when bar then baz; end
    ///           ~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl When {
    #[doc(hidden)]
    pub fn get_patterns(&self) -> &Vec<Node> {
        &self.patterns
    }

    #[doc(hidden)]
    pub fn get_patterns_mut(&mut self) -> &mut Vec<Node> {
        &mut self.patterns
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_patterns(&mut self, value: Vec<Node>) {
        self.patterns = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalWhen {
        let Self { patterns, body, keyword_l, begin_l, expression_l } = self;
        super::InternalWhen { patterns, body, keyword_l, begin_l, expression_l }
    }
}

impl InnerNode for When {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.patterns);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "when"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.patterns.iter() {
          node.inner_ref().print_with_locs();
        }
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.begin_l.print("begin");
        self.expression_l.print("expression");
    }
}
