// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalList as List;

use super::internal::InternalWhen;
use crate::blobs::{HasBlob, Blob};

/// Represents a branch of the `case` statement (i.e. `when foo`)
#[repr(C)]
pub struct When {
    pub(crate) blob: Blob<When>
}

impl std::fmt::Debug for When {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("When")
            .field("patterns", &self.get_patterns())
            .field("body", &self.get_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("begin_l", &self.get_begin_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for When {
    fn eq(&self, other: &Self) -> bool {
        self.get_patterns() == other.get_patterns()
            && self.get_body() == other.get_body()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl When {
    /// Returns `patterns` field
    pub fn get_patterns(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__when__get_patterns(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `patterns` field
    pub fn set_patterns(&mut self, patterns: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__when__set_patterns(&mut self.blob, patterns.into_blob()) }
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__when__get_body(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__when__set_body(&mut self.blob, body.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__when__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__when__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__when__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__when__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__when__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__when__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalWhen {
        unsafe { lib_ruby_parser__external__nodes__when__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__when__get_patterns(blob: *const Blob<When>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__when__set_patterns(blob: *mut Blob<When>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__when__get_body(blob: *const Blob<When>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__when__set_body(blob: *mut Blob<When>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__when__get_keyword_l(blob: *const Blob<When>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__when__set_keyword_l(blob: *mut Blob<When>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__when__get_begin_l(blob: *const Blob<When>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__when__set_begin_l(blob: *mut Blob<When>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__when__get_expression_l(blob: *const Blob<When>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__when__set_expression_l(blob: *mut Blob<When>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__when__into_internal(blob: Blob<When>) -> InternalWhen;
    fn lib_ruby_parser__external__nodes__when__drop(blob: *mut Blob<When>);
}

impl InnerNode for When {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_patterns());
        result.push_maybe_node_or_nil(self.get_body());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "when"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_patterns().iter() {
          node.inner_ref().print_with_locs();
        }
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_begin_l().print("begin");
        self.get_expression_l().print("expression");
    }
}

impl Drop for When {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__when__drop(&mut self.blob) }
    }
}
