// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `until` loop
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Until {
    /// Condition of the loop
    pub cond: Box<Node>,

    /// Body of the loop.
    ///
    /// `None` if body is empty
    pub body: Option<Box<Node>>,

    /// Location of the `until` keyword
    ///
    /// ```text
    /// until cond do; foo; end
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `do` keyword
    ///
    /// ```text
    /// until cond do; foo; end
    ///            ~~
    /// ```
    ///
    /// `do` is optional, and so `begin_l` can be `None`
    pub begin_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// until cond do; foo; end
    ///                     ~~~
    /// ```
    ///
    /// `None` if loop is a modifier (i.e. `foo until bar`)
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// until cond do; foo; end
    /// ~~~~~~~~~~~~~~~~~~~~~~~
    ///
    /// foo until bar
    /// ~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Until {
    #[doc(hidden)]
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    #[doc(hidden)]
    pub fn get_cond_mut(&mut self) -> &mut Box<Node> {
        &mut self.cond
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_cond(&mut self, value: Box<Node>) {
        self.cond = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalUntil {
        let Self { cond, body, keyword_l, begin_l, end_l, expression_l } = self;
        super::InternalUntil { cond, body, keyword_l, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Until {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.cond);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "until"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.cond.inner_ref().print_with_locs();
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.expression_l.print("expression");
    }
}
