// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents regex literal (e.g. `/foo/`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Regexp {
    /// A list of static and dynamic regex parts
    pub parts: Vec<Node>,

    /// Regex options.
    ///
    /// `None` if regex has no explicit flags
    pub options: Option<Box<Node>>,

    /// Location of the regex begin
    ///
    /// ```text
    /// /foo/
    /// ~
    ///
    /// %r{foo}
    /// ~~
    /// ```
    pub begin_l: Loc,

    /// Location of the regex end
    ///
    /// ```text
    /// /foo/
    ///     ~
    ///
    /// %r{foo}
    ///       ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// /foo/mix
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Regexp {
    #[doc(hidden)]
    pub fn get_parts(&self) -> &Vec<Node> {
        &self.parts
    }

    #[doc(hidden)]
    pub fn get_parts_mut(&mut self) -> &mut Vec<Node> {
        &mut self.parts
    }

    #[doc(hidden)]
    pub fn get_options(&self) -> &Option<Box<Node>> {
        &self.options
    }

    #[doc(hidden)]
    pub fn get_options_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.options
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_parts(&mut self, value: Vec<Node>) {
        self.parts = value;
    }

    #[doc(hidden)]
    pub fn set_options(&mut self, value: Option<Box<Node>>) {
        self.options = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalRegexp {
        let Self { parts, options, begin_l, end_l, expression_l } = self;
        super::InternalRegexp { parts, options, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Regexp {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.parts);
        result.push_regex_options(&self.options);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "regexp"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.parts.iter() {
          node.inner_ref().print_with_locs();
        }
        self.options.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
