// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalRational;
use crate::blobs::{HasBlob, Blob};

/// Represents rational literal (e.g. `1r`)
#[repr(C)]
pub struct Rational {
    pub(crate) blob: Blob<Rational>
}

impl std::fmt::Debug for Rational {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Rational")
            .field("value", &self.get_value())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Rational {
    fn eq(&self, other: &Self) -> bool {
        self.get_value() == other.get_value()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Rational {
    /// Returns `value` field
    pub fn get_value(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rational__get_value(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__rational__set_value(&mut self.blob, value.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rational__get_operator_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__rational__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__rational__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__rational__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalRational {
        unsafe { lib_ruby_parser__external__nodes__rational__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__rational__get_value(blob: *const Blob<Rational>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__rational__set_value(blob: *mut Blob<Rational>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__rational__get_operator_l(blob: *const Blob<Rational>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__rational__set_operator_l(blob: *mut Blob<Rational>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__rational__get_expression_l(blob: *const Blob<Rational>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__rational__set_expression_l(blob: *mut Blob<Rational>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__rational__into_internal(blob: Blob<Rational>) -> InternalRational;
    fn lib_ruby_parser__external__nodes__rational__drop(blob: *mut Blob<Rational>);
}

impl InnerNode for Rational {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_value());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "rational"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Rational {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__rational__drop(&mut self.blob) }
    }
}
