// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an operation with assignment (e.g. `a += 1`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct OpAsgn {
    /// Left hand statement of the assignment
    pub recv: Box<Node>,

    /// Operator, can be one of:
    /// 1. `+=`
    /// 2. `-=`
    /// 3. `*=`
    /// 4. `/=`
    /// 5. `|=`
    /// 6. `&=`
    /// 7. `>>=`
    /// 8. `<<=`
    /// 9. `%=`
    /// 10. `^=`
    /// 11. `**=`
    pub operator: String,

    /// Right hand statement of the assignment
    pub value: Box<Node>,

    /// Location of the operator
    ///
    /// ```text
    /// a.b <<= c
    ///     ~~~
    /// ```
    pub operator_l: Loc,

    /// Location of the operator
    ///
    /// ```text
    /// a.b <<= c
    /// ~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl OpAsgn {
    #[doc(hidden)]
    pub fn get_recv(&self) -> &Box<Node> {
        &self.recv
    }

    #[doc(hidden)]
    pub fn get_recv_mut(&mut self) -> &mut Box<Node> {
        &mut self.recv
    }

    #[doc(hidden)]
    pub fn get_operator(&self) -> &String {
        &self.operator
    }

    #[doc(hidden)]
    pub fn get_operator_mut(&mut self) -> &mut String {
        &mut self.operator
    }

    #[doc(hidden)]
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut Box<Node> {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_recv(&mut self, value: Box<Node>) {
        self.recv = value;
    }

    #[doc(hidden)]
    pub fn set_operator(&mut self, value: String) {
        self.operator = value;
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalOpAsgn {
        let Self { recv, operator, value, operator_l, expression_l } = self;
        super::InternalOpAsgn { recv, operator, value, operator_l, expression_l }
    }
}

impl InnerNode for OpAsgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.recv);
        result.push_str(&self.operator);
        result.push_node(&self.value);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "op_asgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.recv.inner_ref().print_with_locs();
        self.value.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
