// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents matching a regex that produces local variables (i.e. `/(?<match>bar)/ =~ 'bar'`)
///
/// Each named group in regex declares a local variable.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchWithLvasgn {
    /// Regex that is used for matching
    pub re: Box<Node>,

    /// Value that is used for matching
    pub value: Box<Node>,

    /// Location of the `=~` operatir
    ///
    /// ```text
    /// /(?<match>bar)/ =~ 'bar'
    ///                 ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// /(?<match>bar)/ =~ 'bar'
    /// ~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl MatchWithLvasgn {
    #[doc(hidden)]
    pub fn get_re(&self) -> &Box<Node> {
        &self.re
    }

    #[doc(hidden)]
    pub fn get_re_mut(&mut self) -> &mut Box<Node> {
        &mut self.re
    }

    #[doc(hidden)]
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut Box<Node> {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_re(&mut self, value: Box<Node>) {
        self.re = value;
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchWithLvasgn {
        let Self { re, value, operator_l, expression_l } = self;
        super::InternalMatchWithLvasgn { re, value, operator_l, expression_l }
    }
}

impl InnerNode for MatchWithLvasgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.re);
        result.push_node(&self.value);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_with_lvasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.re.inner_ref().print_with_locs();
        self.value.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
