// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a one-line pattern matching that can throw an error (i.e. `foo => pattern`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchPattern {
    /// Value that is used for matching
    pub value: Box<Node>,

    /// Pattern that is used for matching
    pub pattern: Box<Node>,

    /// Location of the `=>` operator
    ///
    /// ```text
    /// foo => pattern
    ///     ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo => pattern
    /// ~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl MatchPattern {
    #[doc(hidden)]
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut Box<Node> {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_pattern(&self) -> &Box<Node> {
        &self.pattern
    }

    #[doc(hidden)]
    pub fn get_pattern_mut(&mut self) -> &mut Box<Node> {
        &mut self.pattern
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_pattern(&mut self, value: Box<Node>) {
        self.pattern = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchPattern {
        let Self { value, pattern, operator_l, expression_l } = self;
        super::InternalMatchPattern { value, pattern, operator_l, expression_l }
    }
}

impl InnerNode for MatchPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.value);
        result.push_node(&self.pattern);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.value.inner_ref().print_with_locs();
        self.pattern.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
