// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents empty hash pattern that is used in pattern matching (i.e. `in **nil`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchNilPattern {
    /// Location of the `**` operator
    ///
    /// ```text
    /// in **nil
    ///    ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the name
    ///
    /// ```text
    /// in **nil
    ///      ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// in **nil
    ///    ~~~~~
    /// ```
    pub expression_l: Loc,
}

impl MatchNilPattern {
    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    #[doc(hidden)]
    pub fn get_name_l_mut(&mut self) -> &mut Loc {
        &mut self.name_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_name_l(&mut self, value: Loc) {
        self.name_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchNilPattern {
        let Self { operator_l, name_l, expression_l } = self;
        super::InternalMatchNilPattern { operator_l, name_l, expression_l }
    }
}

impl InnerNode for MatchNilPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_nil_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.operator_l.print("operator");
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
