// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents pattern matching using one of the given patterns (i.e. `foo in 1 | 2`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchAlt {
    /// Left pattern
    pub lhs: Box<Node>,

    /// Right pattern
    pub rhs: Box<Node>,

    /// Location of the `|` operator
    ///
    /// ```text
    /// foo in 1 | 2
    ///          ~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo in 1 | 2
    ///        ~~~~~
    /// ```
    pub expression_l: Loc,
}

impl MatchAlt {
    #[doc(hidden)]
    pub fn get_lhs(&self) -> &Box<Node> {
        &self.lhs
    }

    #[doc(hidden)]
    pub fn get_lhs_mut(&mut self) -> &mut Box<Node> {
        &mut self.lhs
    }

    #[doc(hidden)]
    pub fn get_rhs(&self) -> &Box<Node> {
        &self.rhs
    }

    #[doc(hidden)]
    pub fn get_rhs_mut(&mut self) -> &mut Box<Node> {
        &mut self.rhs
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_lhs(&mut self, value: Box<Node>) {
        self.lhs = value;
    }

    #[doc(hidden)]
    pub fn set_rhs(&mut self, value: Box<Node>) {
        self.rhs = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchAlt {
        let Self { lhs, rhs, operator_l, expression_l } = self;
        super::InternalMatchAlt { lhs, rhs, operator_l, expression_l }
    }
}

impl InnerNode for MatchAlt {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.lhs);
        result.push_node(&self.rhs);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_alt"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.lhs.inner_ref().print_with_locs();
        self.rhs.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
