// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

use super::internal::InternalLine;
use crate::blobs::{HasBlob, Blob};

/// Represents a special `__LINE__` literal
#[repr(C)]
pub struct Line {
    pub(crate) blob: Blob<Line>
}

impl std::fmt::Debug for Line {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Line")
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Line {
    fn eq(&self, other: &Self) -> bool {
        self.get_expression_l() == other.get_expression_l()
    }
}

impl Line {
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__line__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__line__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalLine {
        unsafe { lib_ruby_parser__external__nodes__line__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__line__get_expression_l(blob: *const Blob<Line>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__line__set_expression_l(blob: *mut Blob<Line>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__line__into_internal(blob: Blob<Line>) -> InternalLine;
    fn lib_ruby_parser__external__nodes__line__drop(blob: *mut Blob<Line>);
}

impl InnerNode for Line {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "__LINE__"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Line {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__line__drop(&mut self.blob) }
    }
}
