// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an explicit `begin; end` block.
///
/// The reason why it's different is that
/// ```text
/// begin; foo; end while cond
/// ```
/// is a post-while loop (same with post-until loop)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct KwBegin {
    /// A list of statements
    pub statements: Vec<Node>,

    /// Location of the `begin` keyword
    ///
    /// ```text
    /// begin; foo; end
    /// ~~~~~
    /// ```
    pub begin_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// begin; foo; end
    ///             ~~~
    /// ```
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; foo; bar
    /// ~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl KwBegin {
    #[doc(hidden)]
    pub fn get_statements(&self) -> &Vec<Node> {
        &self.statements
    }

    #[doc(hidden)]
    pub fn get_statements_mut(&mut self) -> &mut Vec<Node> {
        &mut self.statements
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_statements(&mut self, value: Vec<Node>) {
        self.statements = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwBegin {
        let Self { statements, begin_l, end_l, expression_l } = self;
        super::InternalKwBegin { statements, begin_l, end_l, expression_l }
    }
}

impl InnerNode for KwBegin {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.statements);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwbegin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.statements.iter() {
          node.inner_ref().print_with_locs();
        }
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.expression_l.print("expression");
    }
}
