// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalList as List;

use super::internal::InternalIndexAsgn;
use crate::blobs::{HasBlob, Blob};

/// Represents assignment using indexing operation (i.e. `foo[1, 2, 3] = bar`)
#[repr(C)]
pub struct IndexAsgn {
    pub(crate) blob: Blob<IndexAsgn>
}

impl std::fmt::Debug for IndexAsgn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("IndexAsgn")
            .field("recv", &self.get_recv())
            .field("indexes", &self.get_indexes())
            .field("value", &self.get_value())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for IndexAsgn {
    fn eq(&self, other: &Self) -> bool {
        self.get_recv() == other.get_recv()
            && self.get_indexes() == other.get_indexes()
            && self.get_value() == other.get_value()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl IndexAsgn {
    /// Returns `recv` field
    pub fn get_recv(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index_asgn__get_recv(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `recv` field
    pub fn set_recv(&mut self, recv: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__index_asgn__set_recv(&mut self.blob, recv.into_blob()) }
    }

    /// Returns `indexes` field
    pub fn get_indexes(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index_asgn__get_indexes(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `indexes` field
    pub fn set_indexes(&mut self, indexes: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__index_asgn__set_indexes(&mut self.blob, indexes.into_blob()) }
    }

    /// Returns `value` field
    pub fn get_value(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index_asgn__get_value(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__index_asgn__set_value(&mut self.blob, value.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index_asgn__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__index_asgn__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index_asgn__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__index_asgn__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index_asgn__get_operator_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__index_asgn__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index_asgn__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__index_asgn__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalIndexAsgn {
        unsafe { lib_ruby_parser__external__nodes__index_asgn__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__index_asgn__get_recv(blob: *const Blob<IndexAsgn>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__index_asgn__set_recv(blob: *mut Blob<IndexAsgn>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__index_asgn__get_indexes(blob: *const Blob<IndexAsgn>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__index_asgn__set_indexes(blob: *mut Blob<IndexAsgn>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__index_asgn__get_value(blob: *const Blob<IndexAsgn>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__index_asgn__set_value(blob: *mut Blob<IndexAsgn>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__index_asgn__get_begin_l(blob: *const Blob<IndexAsgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__index_asgn__set_begin_l(blob: *mut Blob<IndexAsgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__index_asgn__get_end_l(blob: *const Blob<IndexAsgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__index_asgn__set_end_l(blob: *mut Blob<IndexAsgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__index_asgn__get_operator_l(blob: *const Blob<IndexAsgn>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__index_asgn__set_operator_l(blob: *mut Blob<IndexAsgn>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__index_asgn__get_expression_l(blob: *const Blob<IndexAsgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__index_asgn__set_expression_l(blob: *mut Blob<IndexAsgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__index_asgn__into_internal(blob: Blob<IndexAsgn>) -> InternalIndexAsgn;
    fn lib_ruby_parser__external__nodes__index_asgn__drop(blob: *mut Blob<IndexAsgn>);
}

impl InnerNode for IndexAsgn {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_recv());
        result.push_nodes(self.get_indexes());
        result.push_maybe_node(self.get_value());
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "indexasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_recv().inner_ref().print_with_locs();
        for node in self.get_indexes().iter() {
          node.inner_ref().print_with_locs();
        }
        if let Some(node) = self.get_value().as_ref() { node.inner_ref().print_with_locs() }
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for IndexAsgn {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__index_asgn__drop(&mut self.blob) }
    }
}
