// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `in pattern` branch of the pattern matching
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct InPattern {
    /// Value that is used for matching
    pub pattern: Box<Node>,

    /// Guard that is used for matching
    ///
    /// Optional, so can be `None`
    pub guard: Option<Box<Node>>,

    /// Body of the branch that is invoked if value matches pattern
    pub body: Option<Box<Node>>,

    /// Location of the `in` keyword
    ///
    /// ```text
    /// case value; in pattern; end
    ///             ~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// case value; in pattern then; end
    ///                        ~~~~
    /// ```
    pub begin_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case value; in pattern then; 42; end
    ///             ~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl InPattern {
    #[doc(hidden)]
    pub fn get_pattern(&self) -> &Box<Node> {
        &self.pattern
    }

    #[doc(hidden)]
    pub fn get_pattern_mut(&mut self) -> &mut Box<Node> {
        &mut self.pattern
    }

    #[doc(hidden)]
    pub fn get_guard(&self) -> &Option<Box<Node>> {
        &self.guard
    }

    #[doc(hidden)]
    pub fn get_guard_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.guard
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_pattern(&mut self, value: Box<Node>) {
        self.pattern = value;
    }

    #[doc(hidden)]
    pub fn set_guard(&mut self, value: Option<Box<Node>>) {
        self.guard = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalInPattern {
        let Self { pattern, guard, body, keyword_l, begin_l, expression_l } = self;
        super::InternalInPattern { pattern, guard, body, keyword_l, begin_l, expression_l }
    }
}

impl InnerNode for InPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.pattern);
        result.push_maybe_node_or_nil(&self.guard);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "in_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.pattern.inner_ref().print_with_locs();
        self.guard.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.begin_l.print("begin");
        self.expression_l.print("expression");
    }
}
