// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `if`/`unless` modifier (i.e. `stmt if cond`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IfMod {
    /// Condition of the modifier
    pub cond: Box<Node>,

    /// True-branch of the modifier.
    ///
    /// Always set for `if` modifier.
    /// Always `None` for `unless` modifier.
    pub if_true: Option<Box<Node>>,

    /// False-branch of the modifier.
    ///
    /// Always set for `unless` modifier.
    /// Always `None` for `if` modifier.
    pub if_false: Option<Box<Node>>,

    /// Location of the `if`/`unless` keyword
    ///
    /// ```text
    /// stmt if cond
    ///      ~~
    ///
    /// stmt unless cond
    ///      ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// stmt if cond
    /// ~~~~~~~~~~~~
    ///
    /// stmt unless cond
    /// ~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl IfMod {
    #[doc(hidden)]
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    #[doc(hidden)]
    pub fn get_cond_mut(&mut self) -> &mut Box<Node> {
        &mut self.cond
    }

    #[doc(hidden)]
    pub fn get_if_true(&self) -> &Option<Box<Node>> {
        &self.if_true
    }

    #[doc(hidden)]
    pub fn get_if_true_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.if_true
    }

    #[doc(hidden)]
    pub fn get_if_false(&self) -> &Option<Box<Node>> {
        &self.if_false
    }

    #[doc(hidden)]
    pub fn get_if_false_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.if_false
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_cond(&mut self, value: Box<Node>) {
        self.cond = value;
    }

    #[doc(hidden)]
    pub fn set_if_true(&mut self, value: Option<Box<Node>>) {
        self.if_true = value;
    }

    #[doc(hidden)]
    pub fn set_if_false(&mut self, value: Option<Box<Node>>) {
        self.if_false = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIfMod {
        let Self { cond, if_true, if_false, keyword_l, expression_l } = self;
        super::InternalIfMod { cond, if_true, if_false, keyword_l, expression_l }
    }
}

impl InnerNode for IfMod {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.cond);
        result.push_maybe_node_or_nil(&self.if_true);
        result.push_maybe_node_or_nil(&self.if_false);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.cond.inner_ref().print_with_locs();
        self.if_true.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.if_false.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.expression_l.print("expression");
    }
}
