// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `if` statement (i.e. `if foo; bar; else; baz; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct If {
    /// Condition given to the `if` statement, `Lvar("a")` for `if a; b; else; c; end`
    pub cond: Box<Node>,

    /// True-branch of the `if` statement, `Lvar("b")` for `if a; b; else; c; end`
    pub if_true: Option<Box<Node>>,

    /// False-branch of the `if` statement, `Lvar("c")` for `if a; b; else; c; end`
    pub if_false: Option<Box<Node>>,

    /// Location of the `if` keyword
    ///
    /// ```text
    /// if foo; end
    /// ~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// if foo then; end
    ///        ~~~~
    /// ```
    ///
    /// `None` if `then` keyword is omitted
    pub begin_l: Loc,

    /// Location of the `else` keyword
    ///
    /// ```text
    /// if foo; else; end
    ///         ~~~~
    /// ```
    ///
    /// `None` if there's no `else` branch
    pub else_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// if foo; end
    ///         ~~~
    /// ```
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// if a then; b; else; c end
    /// ~~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl If {
    #[doc(hidden)]
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    #[doc(hidden)]
    pub fn get_cond_mut(&mut self) -> &mut Box<Node> {
        &mut self.cond
    }

    #[doc(hidden)]
    pub fn get_if_true(&self) -> &Option<Box<Node>> {
        &self.if_true
    }

    #[doc(hidden)]
    pub fn get_if_true_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.if_true
    }

    #[doc(hidden)]
    pub fn get_if_false(&self) -> &Option<Box<Node>> {
        &self.if_false
    }

    #[doc(hidden)]
    pub fn get_if_false_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.if_false
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_else_l(&self) -> &Option<Loc> {
        &self.else_l
    }

    #[doc(hidden)]
    pub fn get_else_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.else_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_cond(&mut self, value: Box<Node>) {
        self.cond = value;
    }

    #[doc(hidden)]
    pub fn set_if_true(&mut self, value: Option<Box<Node>>) {
        self.if_true = value;
    }

    #[doc(hidden)]
    pub fn set_if_false(&mut self, value: Option<Box<Node>>) {
        self.if_false = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_else_l(&mut self, value: Option<Loc>) {
        self.else_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIf {
        let Self { cond, if_true, if_false, keyword_l, begin_l, else_l, end_l, expression_l } = self;
        super::InternalIf { cond, if_true, if_false, keyword_l, begin_l, else_l, end_l, expression_l }
    }
}

impl InnerNode for If {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.cond);
        result.push_maybe_node_or_nil(&self.if_true);
        result.push_maybe_node_or_nil(&self.if_false);
        
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.cond.inner_ref().print_with_locs();
        self.if_true.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.if_false.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.begin_l.print("begin");
        self.else_l.as_ref().map(|loc| loc.print("else"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.expression_l.print("expression");
    }
}
