// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalIf;
use crate::blobs::{HasBlob, Blob};

/// Represents an `if` statement (i.e. `if foo; bar; else; baz; end`)
#[repr(C)]
pub struct If {
    pub(crate) blob: Blob<If>
}

impl std::fmt::Debug for If {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("If")
            .field("cond", &self.get_cond())
            .field("if_true", &self.get_if_true())
            .field("if_false", &self.get_if_false())
            .field("keyword_l", &self.get_keyword_l())
            .field("begin_l", &self.get_begin_l())
            .field("else_l", &self.get_else_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for If {
    fn eq(&self, other: &Self) -> bool {
        self.get_cond() == other.get_cond()
            && self.get_if_true() == other.get_if_true()
            && self.get_if_false() == other.get_if_false()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_else_l() == other.get_else_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl If {
    /// Returns `cond` field
    pub fn get_cond(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if__get_cond(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__if__set_cond(&mut self.blob, cond.into_blob()) }
    }

    /// Returns `if_true` field
    pub fn get_if_true(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if__get_if_true(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `if_true` field
    pub fn set_if_true(&mut self, if_true: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__if__set_if_true(&mut self.blob, if_true.into_blob()) }
    }

    /// Returns `if_false` field
    pub fn get_if_false(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if__get_if_false(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `if_false` field
    pub fn set_if_false(&mut self, if_false: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__if__set_if_false(&mut self.blob, if_false.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `else_l` field
    pub fn get_else_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if__get_else_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `else_l` field
    pub fn set_else_l(&mut self, else_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__if__set_else_l(&mut self.blob, else_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if__get_end_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__if__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__if__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__if__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalIf {
        unsafe { lib_ruby_parser__external__nodes__if__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__if__get_cond(blob: *const Blob<If>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__if__set_cond(blob: *mut Blob<If>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__if__get_if_true(blob: *const Blob<If>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__if__set_if_true(blob: *mut Blob<If>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__if__get_if_false(blob: *const Blob<If>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__if__set_if_false(blob: *mut Blob<If>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__if__get_keyword_l(blob: *const Blob<If>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if__set_keyword_l(blob: *mut Blob<If>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if__get_begin_l(blob: *const Blob<If>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if__set_begin_l(blob: *mut Blob<If>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if__get_else_l(blob: *const Blob<If>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__if__set_else_l(blob: *mut Blob<If>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__if__get_end_l(blob: *const Blob<If>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__if__set_end_l(blob: *mut Blob<If>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__if__get_expression_l(blob: *const Blob<If>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__if__set_expression_l(blob: *mut Blob<If>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__if__into_internal(blob: Blob<If>) -> InternalIf;
    fn lib_ruby_parser__external__nodes__if__drop(blob: *mut Blob<If>);
}

impl InnerNode for If {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());
        result.push_maybe_node_or_nil(self.get_if_true());
        result.push_maybe_node_or_nil(self.get_if_false());
        
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        if let Some(node) = self.get_if_true().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_if_false().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_begin_l().print("begin");
        if let Some(loc) = self.get_else_l().as_ref() { loc.print("else") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for If {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__if__drop(&mut self.blob) }
    }
}
