// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

use super::internal::InternalEmptyElse;
use crate::blobs::{HasBlob, Blob};

/// Represents a special empty else that is a part of the pattern matching.
///
/// Usually empty else (e.g. part of the `if` statement) doesn't mean anything,
/// however in pattern matching it prevents raising a `NoPatternError`.
///
/// Throwing away this `else` may affect your code.
#[repr(C)]
pub struct EmptyElse {
    pub(crate) blob: Blob<EmptyElse>
}

impl std::fmt::Debug for EmptyElse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("EmptyElse")
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for EmptyElse {
    fn eq(&self, other: &Self) -> bool {
        self.get_expression_l() == other.get_expression_l()
    }
}

impl EmptyElse {
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__empty_else__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__empty_else__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalEmptyElse {
        unsafe { lib_ruby_parser__external__nodes__empty_else__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__empty_else__get_expression_l(blob: *const Blob<EmptyElse>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__empty_else__set_expression_l(blob: *mut Blob<EmptyElse>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__empty_else__into_internal(blob: Blob<EmptyElse>) -> InternalEmptyElse;
    fn lib_ruby_parser__external__nodes__empty_else__drop(blob: *mut Blob<EmptyElse>);
}

impl InnerNode for EmptyElse {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "empty_else"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for EmptyElse {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__empty_else__drop(&mut self.blob) }
    }
}
