// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents constant access (i.e. `Foo::Bar`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Const {
    /// Scope where the constant is taken from:
    /// 1. `Some(Const("A"))` for `A::B`
    /// 2. `None` if it's taken from the current scope (i.e. `A`)
    /// 3. `Some(Cbase)` if it's taken from the global scope (i.e. `::A`)
    pub scope: Option<Box<Node>>,

    /// Name of the constant, `String("Foo")` for `Foo`
    pub name: String,

    /// Location of the `::` operator. `None` if constant is taken from the current scope.
    ///
    /// ```text
    /// A::B
    ///  ~~
    /// ```
    pub double_colon_l: Option<Loc>,

    /// Location of the constant name
    ///
    /// ```text
    /// Foo::Bar
    ///      ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// Foo::Bar
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Const {
    #[doc(hidden)]
    pub fn get_scope(&self) -> &Option<Box<Node>> {
        &self.scope
    }

    #[doc(hidden)]
    pub fn get_scope_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.scope
    }

    #[doc(hidden)]
    pub fn get_name(&self) -> &String {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut String {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_double_colon_l(&self) -> &Option<Loc> {
        &self.double_colon_l
    }

    #[doc(hidden)]
    pub fn get_double_colon_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.double_colon_l
    }

    #[doc(hidden)]
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    #[doc(hidden)]
    pub fn get_name_l_mut(&mut self) -> &mut Loc {
        &mut self.name_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_scope(&mut self, value: Option<Box<Node>>) {
        self.scope = value;
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: String) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_double_colon_l(&mut self, value: Option<Loc>) {
        self.double_colon_l = value;
    }

    #[doc(hidden)]
    pub fn set_name_l(&mut self, value: Loc) {
        self.name_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalConst {
        let Self { scope, name, double_colon_l, name_l, expression_l } = self;
        super::InternalConst { scope, name, double_colon_l, name_l, expression_l }
    }
}

impl InnerNode for Const {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.scope);
        result.push_str(&self.name);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "const"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.scope.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.double_colon_l.as_ref().map(|loc| loc.print("double_colon"));
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
