// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a class definition (using a `class` keyword, `Class.new` is just a method call)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Class {
    /// Name of the class, `String("Foo")` for `class Foo; end`
    pub name: Box<Node>,

    /// Superclass. Can be an expression in cases like `class A < (obj.foo + 1); end`
    ///
    /// `None` if no explicit superclass given (i.e. `class Foo; end`)
    pub superclass: Option<Box<Node>>,

    /// Body of the method, `None` if there's no body.
    pub body: Option<Box<Node>>,

    /// Location of the `class` keyword.
    ///
    /// ```text
    /// class Foo; end
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `<` operator
    ///
    /// ```text
    /// class A < B; end
    ///         ~
    /// ```
    ///
    /// `None` if there's no explicit superclass given.
    pub operator_l: Option<Loc>,

    /// Location of the `end` keyword.
    ///
    /// ```text
    /// class Foo; end
    ///            ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// class Foo; end
    /// ~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Class {
    #[doc(hidden)]
    pub fn get_name(&self) -> &Box<Node> {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut Box<Node> {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_superclass(&self) -> &Option<Box<Node>> {
        &self.superclass
    }

    #[doc(hidden)]
    pub fn get_superclass_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.superclass
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: Box<Node>) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_superclass(&mut self, value: Option<Box<Node>>) {
        self.superclass = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Option<Loc>) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalClass {
        let Self { name, superclass, body, keyword_l, operator_l, end_l, expression_l } = self;
        super::InternalClass { name, superclass, body, keyword_l, operator_l, end_l, expression_l }
    }
}

impl InnerNode for Class {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.name);
        result.push_maybe_node_or_nil(&self.superclass);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "class"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.name.inner_ref().print_with_locs();
        self.superclass.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.operator_l.as_ref().map(|loc| loc.print("operator"));
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
