// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a `&blk` argument in the method definition (but not in the method call, see `BlockPass`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Blockarg {
    /// Name of the argument, `String("foo")` for `def m(&foo)`
    pub name: String,

    /// Location of the `&` operator
    ///
    /// ```text
    /// def m(&foo); end
    ///       ~
    /// ```
    pub operator_l: Loc,

    /// Location of the name
    ///
    /// ```text
    /// def m(&foo); end
    ///        ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(&foo); end
    ///       ~~~~
    /// ```
    pub expression_l: Loc,
}

impl Blockarg {
    #[doc(hidden)]
    pub fn get_name(&self) -> &String {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut String {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    #[doc(hidden)]
    pub fn get_name_l_mut(&mut self) -> &mut Loc {
        &mut self.name_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: String) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_name_l(&mut self, value: Loc) {
        self.name_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalBlockarg {
        let Self { name, operator_l, name_l, expression_l } = self;
        super::InternalBlockarg { name, operator_l, name_l, expression_l }
    }
}

impl InnerNode for Blockarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "blockarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.operator_l.print("operator");
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
