// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a Ruby block that is passed to a method (`proc { |foo| bar }`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Block {
    /// Method call that takes a block
    ///
    /// `Send("foo")` in `foo {}`
    pub call: Box<Node>,

    /// A list of argument that block takes
    ///
    /// `vec![ Arg("a"), Optarg("b", Int("1")) ]` for `proc { |a, b = 1| }`
    ///
    /// `None` if the block takes no arguments
    pub args: Option<Box<Node>>,

    /// Block body, `None` if block has no body.
    pub body: Option<Box<Node>>,

    /// Location of the open brace
    ///
    /// ```text
    /// proc { }
    ///      ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing brace
    ///
    /// ```text
    /// proc { }
    ///        ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// proc { }
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Block {
    #[doc(hidden)]
    pub fn get_call(&self) -> &Box<Node> {
        &self.call
    }

    #[doc(hidden)]
    pub fn get_call_mut(&mut self) -> &mut Box<Node> {
        &mut self.call
    }

    #[doc(hidden)]
    pub fn get_args(&self) -> &Option<Box<Node>> {
        &self.args
    }

    #[doc(hidden)]
    pub fn get_args_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.args
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_call(&mut self, value: Box<Node>) {
        self.call = value;
    }

    #[doc(hidden)]
    pub fn set_args(&mut self, value: Option<Box<Node>>) {
        self.args = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalBlock {
        let Self { call, args, body, begin_l, end_l, expression_l } = self;
        super::InternalBlock { call, args, body, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Block {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.call);
        result.push_maybe_node_or_nil(&self.args);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "block"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.call.inner_ref().print_with_locs();
        self.args.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
