// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalList as List;

use super::internal::InternalArgs;
use crate::blobs::{HasBlob, Blob};

/// Represents an arguments list
///
/// `Args(vec![Arg("a"), Optarg("b", Int("1"))])` in `def m(a, b = 1); end`
#[repr(C)]
pub struct Args {
    pub(crate) blob: Blob<Args>
}

impl std::fmt::Debug for Args {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Args")
            .field("args", &self.get_args())
            .field("expression_l", &self.get_expression_l())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .finish()
    }
}

impl PartialEq for Args {
    fn eq(&self, other: &Self) -> bool {
        self.get_args() == other.get_args()
            && self.get_expression_l() == other.get_expression_l()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
    }
}

impl Args {
    /// Returns `args` field
    pub fn get_args(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__args__get_args(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__args__set_args(&mut self.blob, args.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__args__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__args__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__args__get_begin_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__args__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__args__get_end_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__args__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalArgs {
        unsafe { lib_ruby_parser__external__nodes__args__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__args__get_args(blob: *const Blob<Args>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__args__set_args(blob: *mut Blob<Args>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__args__get_expression_l(blob: *const Blob<Args>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__args__set_expression_l(blob: *mut Blob<Args>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__args__get_begin_l(blob: *const Blob<Args>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__args__set_begin_l(blob: *mut Blob<Args>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__args__get_end_l(blob: *const Blob<Args>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__args__set_end_l(blob: *mut Blob<Args>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__args__into_internal(blob: Blob<Args>) -> InternalArgs;
    fn lib_ruby_parser__external__nodes__args__drop(blob: *mut Blob<Args>);
}

impl InnerNode for Args {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_args());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "args"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_args().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_expression_l().print("expression");
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
    }
}

impl Drop for Args {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__args__drop(&mut self.blob) }
    }
}
