fn contents() -> String {
    let sections = lib_ruby_parser_nodes::message_sections();

    format!(
        "// This file is autogenerated by {generator}

use super::variants::*;

/// Enum of all possible diagnostic message (both warnings and errors)
#[derive(Debug, Clone, PartialEq, Eq)]
#[allow(missing_docs)]
pub enum DiagnosticMessage {{
    {all_variants}
}}
",
        generator = file!(),
        all_variants = sections.map(section_variants).join(",\n    ")
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/native/enum_.rs", contents()).unwrap();
}

fn section_variants(section: &lib_ruby_parser_nodes::Section) -> String {
    let variants = section
        .messages
        .map(|message| format!("{variant}({variant})", variant = message.camelcase_name));

    format!(
        "// {section_name}
    {variants}",
        section_name = section.name,
        variants = variants.join(",\n    ")
    )
}
