pub(crate) fn codegen() {
    std::fs::write("external/cpp/sizes_gen.hpp", contents()).unwrap();
}

fn contents() -> String {
    let nodes = lib_ruby_parser_nodes::nodes();
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "#ifndef LIB_RUBY_PARSER_SIZES_GEN_HPP
#define LIB_RUBY_PARSER_SIZES_GEN_HPP

// This file is autogenerated by {generator}

#include <iostream>
#include \"structs.hpp\"

using namespace lib_ruby_parser;

void print_node_sizes()
{{
    {node_sizes}
}}

void print_messages_sizes()
{{
    {message_sizes}
}}

#endif // LIB_RUBY_PARSER_SIZES_GEN_HPP
",
        generator = file!(),
        node_sizes = nodes.map(node_size).join("\n    "),
        message_sizes = messages.map(message_size).join("\n    ")
    )
}

fn node_size(node: &lib_ruby_parser_nodes::Node) -> String {
    format!(
        "std::cout << \"LIB_RUBY_PARSER_NODE_{upper}_SIZE=\" << sizeof({struct_name}) << \"\\n\";",
        upper = node.upper_name(),
        struct_name = node.camelcase_name
    )
}

fn message_size(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "std::cout << \"LIB_RUBY_PARSER_MESSAGE_{upper}_SIZE=\" << sizeof({struct_name}) << \"\\n\";",
        upper = message.upper_name(),
        struct_name = message.camelcase_name
    )
}
