use crate::codegen::cpp::helpers as cpp_helpers;

fn contents() -> String {
    let nodes = lib_ruby_parser_nodes::nodes();

    format!(
        "#ifndef LIB_RUBY_PARSER_EXTERNAL_C_NODES_HPP
#define LIB_RUBY_PARSER_EXTERNAL_C_NODES_HPP

// This file is autogenerated by {generator}

#include <variant>

namespace lib_ruby_parser
{{
    class Node;
    typedef std::unique_ptr<Node> NodePtr;
    typedef std::unique_ptr<Node> MaybeNodePtr;
    using NodeList = std::vector<Node>;

    {structs}

    typedef std::variant<
        {variants}>
        node_variant_t;

    class Node
    {{
    public:
        node_variant_t variant;

        Node(node_variant_t variant);

        Node(const Node &) = delete;
        Node &operator=(const Node &other) = delete;

        Node(Node &&) = default;
        Node &operator=(Node &&other) = default;
    }};

    void drop_node(Node *node);
    void drop_maybe_node_ptr(std::unique_ptr<Node> *node);
    void drop_node_ptr(std::unique_ptr<Node> *node);
    void drop_node_list(NodeList *node_list);
}}

#endif // LIB_RUBY_PARSER_EXTERNAL_C_NODES_HPP
",
        generator = file!(),
        structs = nodes.map(struct_declaration).join("\n\n    "),
        variants = nodes.map(variant).join(",\n        "),
    )
}

pub(crate) fn codegen() {
    std::fs::write("external/cpp/nodes.hpp", contents()).unwrap();
}

fn struct_declaration(node: &lib_ruby_parser_nodes::Node) -> String {
    let fields = node.fields.map(|field| {
        format!(
            "{} {};",
            cpp_helpers::nodes::field_type(field),
            cpp_helpers::nodes::field_name(field)
        )
    });

    let constructor_args = node
        .fields
        .map(|field| {
            format!(
                "{} {}",
                cpp_helpers::nodes::field_type(field),
                cpp_helpers::nodes::field_name(field)
            )
        })
        .join(", ");

    format!(
        "class {class_name}
    {{
    public:
        {fields}

        explicit {class_name}({constructor_args});

        {class_name}(const {class_name} &) = delete;
        {class_name} &operator=(const {class_name} &other) = delete;

        {class_name}({class_name} &&) = default;
        {class_name} &operator=({class_name} &&other) = default;
    }};",
        class_name = node.camelcase_name,
        fields = fields.join("\n        "),
        constructor_args = constructor_args
    )
}
fn variant(node: &lib_ruby_parser_nodes::Node) -> String {
    node.camelcase_name.to_owned()
}
