use crate::codegen::c::helpers;

fn contents() -> String {
    let nodes = lib_ruby_parser_nodes::nodes();

    format!(
        "#ifndef LIB_RUBY_PARSER_EXTERNAL_C_NODES_H
#define LIB_RUBY_PARSER_EXTERNAL_C_NODES_H

// This file is autogenerated by {generator}

struct LIB_RUBY_PARSER_Node;
typedef struct LIB_RUBY_PARSER_Node LIB_RUBY_PARSER_Node;
struct LIB_RUBY_PARSER_Node_BLOB;
typedef struct LIB_RUBY_PARSER_Node_BLOB LIB_RUBY_PARSER_Node_BLOB;
typedef struct LIB_RUBY_PARSER_NodeList
{{
    LIB_RUBY_PARSER_Node *ptr;
    uint64_t len;
    uint64_t capacity;
}} LIB_RUBY_PARSER_NodeList;

typedef LIB_RUBY_PARSER_Node* LIB_RUBY_PARSER_NodePtr;
typedef LIB_RUBY_PARSER_Node* LIB_RUBY_PARSER_MaybeNodePtr;

{structs}

struct LIB_RUBY_PARSER_Node {{
    enum {{
        {enum_variants}
    }} tag;
    union {{
        {union_members}
    }} as;
}};

{drop_fns}

void LIB_RUBY_PARSER_drop_node(LIB_RUBY_PARSER_Node *node);
void LIB_RUBY_PARSER_drop_maybe_node_ptr(LIB_RUBY_PARSER_Node **node);
void LIB_RUBY_PARSER_drop_node_ptr(LIB_RUBY_PARSER_Node **node);
void LIB_RUBY_PARSER_drop_node_list(LIB_RUBY_PARSER_NodeList *node_list);

#endif // LIB_RUBY_PARSER_EXTERNAL_C_NODES_H
",
        generator = file!(),
        structs = nodes.map(struct_declaration).join("\n\n"),
        enum_variants = nodes.map(enum_variant).join(",\n    "),
        union_members = nodes.map(union_member).join("\n        "),
        drop_fns = nodes.map(drop_fn).join("\n")
    )
}

pub(crate) fn codegen() {
    std::fs::write("external/c/nodes.h", contents()).unwrap();
}

fn struct_declaration(node: &lib_ruby_parser_nodes::Node) -> String {
    let fields = node.fields.map(|field| {
        format!(
            "{} {};",
            helpers::nodes::fields::field_type(field),
            helpers::nodes::fields::field_name(field)
        )
    });

    format!(
        "typedef struct LIB_RUBY_PARSER_{struct_name}
{{
    {fields}
}} LIB_RUBY_PARSER_{struct_name};",
        struct_name = node.camelcase_name,
        fields = fields.join("\n    ")
    )
}
fn enum_variant(node: &lib_ruby_parser_nodes::Node) -> String {
    helpers::nodes::enum_variant_name(node)
}
fn union_member(node: &lib_ruby_parser_nodes::Node) -> String {
    format!(
        "LIB_RUBY_PARSER_{node_type} {union_member_name};",
        node_type = node.camelcase_name,
        union_member_name = helpers::nodes::union_member_name(node)
    )
}

fn drop_fn(node: &lib_ruby_parser_nodes::Node) -> String {
    format!(
        "void LIB_RUBY_PARSER_drop_node_{lower}(LIB_RUBY_PARSER_{struct_name} *variant);",
        lower = node.lower_name(),
        struct_name = node.camelcase_name
    )
}
