pub(crate) mod helpers;

mod bindings_messages_c;
mod messages_c;
mod messages_h;

mod bindings_nodes_c;
mod nodes_c;
mod nodes_h;

mod bindings_h;

mod blobs_gen_h;
mod sizes_gen_h;

pub(crate) fn codegen() {
    let options = codegen_options();

    bindings_messages_c::codegen(&options);

    messages_h::codegen();
    messages_c::codegen();

    bindings_nodes_c::codegen(&options);

    nodes_h::codegen();
    nodes_c::codegen();

    bindings_h::codegen(&options);

    blobs_gen_h::codegen();
    sizes_gen_h::codegen();
}

fn ns(s: &str) -> String {
    format!("LIB_RUBY_PARSER_{}_BLOB", s)
}

pub(crate) fn codegen_options() -> lib_ruby_parser_bindings::Options {
    let pre_code = format!(
        "// This file is autogenerated by {generator}
#include \"structs.h\"
#include \"blobs.h\"",
        generator = file!()
    );

    lib_ruby_parser_bindings::Options {
        pre_code,

        // blob names
        ptr_blob_name: ns("Ptr"),
        maybe_ptr_blob_name: ns("MaybePtr"),
        string_ptr_blob_name: ns("StringPtr"),
        maybe_string_ptr_blob_name: ns("MaybeStringPtr"),
        shared_byte_list_blob_name: ns("SharedByteList"),
        byte_blob_name: ns("Byte"),
        token_blob_name: ns("Token"),
        node_blob_name: ns("Node"),
        diagnostic_blob_name: ns("Diagnostic"),
        comment_type_blob_name: ns("CommentType"),
        comment_blob_name: ns("Comment"),
        magic_comment_kind_blob_name: ns("MagicCommentKind"),
        magic_comment_blob_name: ns("MagicComment"),
        source_line_blob_name: ns("SourceLine"),
        bytes_blob_name: ns("Bytes"),
        loc_blob_name: ns("Loc"),
        maybe_loc_blob_name: ns("MaybeLoc"),
        error_level_blob_name: ns("ErrorLevel"),
        diagnostic_message_blob_name: ns("DiagnosticMessage"),

        // list blob names
        byte_list_blob_name: ns("ByteList"),
        token_list_blob_name: ns("TokenList"),
        node_list_blob_name: ns("NodeList"),
        diagnostic_list_blob_name: ns("DiagnosticList"),
        comment_list_blob_name: ns("CommentList"),
        magic_comment_list_blob_name: ns("MagicCommentList"),
        source_line_list_blob_name: ns("SourceLineList"),

        // messages
        message_variant_blob_name_fn: Box::new(&|message: &lib_ruby_parser_nodes::Message| {
            ns(message.camelcase_name)
        }),

        // nodes
        node_variant_blob_name_fn: Box::new(&|node: &lib_ruby_parser_nodes::Node| {
            ns(node.camelcase_name)
        }),

        input_error_blob_name: ns("InputError"),
        decoder_result_blob_name: ns("DecoderResult"),
        decoder_blob_name: ns("Decoder"),

        rewrite_action_blob_name: ns("RewriteAction"),
        lex_state_action_blob_name: ns("LexStateAction"),
        token_rewriter_result_blob_name: ns("TokenRewriterResult"),
        token_rewriter_blob_name: ns("TokenRewriter"),

        maybe_decoder_blob_name: ns("MaybeDecoder"),
        maybe_token_rewriter_blob_name: ns("MaybeTokenRewriter"),
        parser_options_blob_name: ns("ParserOptions"),

        decoded_input_blob_name: ns("DecodedInput"),
        parser_result_blob_name: ns("ParserResult"),
        ..Default::default()
    }
}
