// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalList as List;

use super::internal::InternalUndef;
use crate::blobs::{HasBlob, Blob};

/// Represents an `undef` keyword (e.g. `undef foo, :bar`)
#[repr(C)]
pub struct Undef {
    pub(crate) blob: Blob<Undef>
}

impl std::fmt::Debug for Undef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Undef")
            .field("names", &self.get_names())
            .field("keyword_l", &self.get_keyword_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Undef {
    fn eq(&self, other: &Self) -> bool {
        self.get_names() == other.get_names()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Undef {
    /// Returns `names` field
    pub fn get_names(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__undef__get_names(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `names` field
    pub fn set_names(&mut self, names: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__undef__set_names(&mut self.blob, names.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__undef__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__undef__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__undef__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__undef__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalUndef {
        unsafe { lib_ruby_parser__external__nodes__undef__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__undef__get_names(blob: *const Blob<Undef>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__undef__set_names(blob: *mut Blob<Undef>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__undef__get_keyword_l(blob: *const Blob<Undef>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__undef__set_keyword_l(blob: *mut Blob<Undef>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__undef__get_expression_l(blob: *const Blob<Undef>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__undef__set_expression_l(blob: *mut Blob<Undef>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__undef__into_internal(blob: Blob<Undef>) -> InternalUndef;
    fn lib_ruby_parser__external__nodes__undef__drop(blob: *mut Blob<Undef>);
}

impl InnerNode for Undef {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_names());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "undef"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_names().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Undef {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__undef__drop(&mut self.blob) }
    }
}
