// This file is autogenerated by codegen/rust/nodes/node_file/tests.rs

crate::use_native_or_external!(Ptr);
crate::use_native_or_external!(StringPtr);
crate::use_native_or_external!(List);
crate::use_native_or_external!(Maybe);

use crate::{Node, Loc, Bytes};
#[allow(unused_imports)]
use super::Retry;

fn new_loc() -> Loc {
    Loc::new(1, 2)
}

#[allow(dead_code)]
fn new_maybe_loc() -> Maybe<Loc> {
    Maybe::some(new_loc())
}

#[allow(dead_code)]
fn new_node() -> Node {
    Node::new_retry(new_loc())
}

#[allow(dead_code)]
fn new_node_ptr() -> Ptr<Node> {
    Ptr::new(new_node())
}

#[allow(dead_code)]
fn new_maybe_node_ptr() -> Maybe<Ptr<Node>> {
    Maybe::some(new_node_ptr())
}

#[allow(dead_code)]
fn new_string_ptr() -> StringPtr {
    StringPtr::from("foo")
}

#[allow(dead_code)]
fn new_maybe_string_ptr() -> Maybe<StringPtr> {
    Maybe::some(new_string_ptr())
}

#[allow(dead_code)]
fn new_node_list() -> List<Node> {
    list![new_node()]
}

#[allow(dead_code)]
fn new_u8() -> u8 {
    42
}

#[allow(dead_code)]
fn new_bytes() -> Bytes {
    Bytes::new(list![1, 2, 3])
}

fn new_test_node() -> Node {
    Node::new_retry(new_loc())
}

#[test]
fn test_constructor() {
    let node = new_test_node();
    drop(node);
}


#[test]
fn test_is() {
    let node = new_test_node();
    assert!(node.is_retry());

    assert!(!node.is_alias());
    assert!(!node.is_and_asgn());
    assert!(!node.is_and());
    assert!(!node.is_arg());
    assert!(!node.is_args());
    assert!(!node.is_array());
    assert!(!node.is_array_pattern());
    assert!(!node.is_array_pattern_with_tail());
    assert!(!node.is_back_ref());
    assert!(!node.is_begin());
    assert!(!node.is_block());
    assert!(!node.is_block_pass());
    assert!(!node.is_blockarg());
    assert!(!node.is_break());
    assert!(!node.is_case());
    assert!(!node.is_case_match());
    assert!(!node.is_casgn());
    assert!(!node.is_cbase());
    assert!(!node.is_class());
    assert!(!node.is_complex());
    assert!(!node.is_const());
    assert!(!node.is_const_pattern());
    assert!(!node.is_c_send());
    assert!(!node.is_cvar());
    assert!(!node.is_cvasgn());
    assert!(!node.is_def());
    assert!(!node.is_defined());
    assert!(!node.is_defs());
    assert!(!node.is_dstr());
    assert!(!node.is_dsym());
    assert!(!node.is_e_flip_flop());
    assert!(!node.is_empty_else());
    assert!(!node.is_encoding());
    assert!(!node.is_ensure());
    assert!(!node.is_erange());
    assert!(!node.is_false());
    assert!(!node.is_file());
    assert!(!node.is_find_pattern());
    assert!(!node.is_float());
    assert!(!node.is_for());
    assert!(!node.is_forward_arg());
    assert!(!node.is_forwarded_args());
    assert!(!node.is_gvar());
    assert!(!node.is_gvasgn());
    assert!(!node.is_hash());
    assert!(!node.is_kwargs());
    assert!(!node.is_hash_pattern());
    assert!(!node.is_heredoc());
    assert!(!node.is_if());
    assert!(!node.is_if_guard());
    assert!(!node.is_if_mod());
    assert!(!node.is_if_ternary());
    assert!(!node.is_i_flip_flop());
    assert!(!node.is_match_pattern());
    assert!(!node.is_match_pattern_p());
    assert!(!node.is_in_pattern());
    assert!(!node.is_index());
    assert!(!node.is_index_asgn());
    assert!(!node.is_int());
    assert!(!node.is_irange());
    assert!(!node.is_ivar());
    assert!(!node.is_ivasgn());
    assert!(!node.is_kwarg());
    assert!(!node.is_kw_begin());
    assert!(!node.is_kwnilarg());
    assert!(!node.is_kwoptarg());
    assert!(!node.is_kwrestarg());
    assert!(!node.is_kwsplat());
    assert!(!node.is_lambda());
    assert!(!node.is_line());
    assert!(!node.is_lvar());
    assert!(!node.is_lvasgn());
    assert!(!node.is_masgn());
    assert!(!node.is_match_alt());
    assert!(!node.is_match_as());
    assert!(!node.is_match_current_line());
    assert!(!node.is_match_nil_pattern());
    assert!(!node.is_match_rest());
    assert!(!node.is_match_var());
    assert!(!node.is_match_with_lvasgn());
    assert!(!node.is_mlhs());
    assert!(!node.is_module());
    assert!(!node.is_next());
    assert!(!node.is_nil());
    assert!(!node.is_nth_ref());
    assert!(!node.is_numblock());
    assert!(!node.is_op_asgn());
    assert!(!node.is_optarg());
    assert!(!node.is_or());
    assert!(!node.is_or_asgn());
    assert!(!node.is_pair());
    assert!(!node.is_pin());
    assert!(!node.is_postexe());
    assert!(!node.is_preexe());
    assert!(!node.is_procarg0());
    assert!(!node.is_rational());
    assert!(!node.is_redo());
    assert!(!node.is_reg_opt());
    assert!(!node.is_regexp());
    assert!(!node.is_rescue());
    assert!(!node.is_rescue_body());
    assert!(!node.is_restarg());
    assert!(!node.is_return());
    assert!(!node.is_s_class());
    assert!(!node.is_self());
    assert!(!node.is_send());
    assert!(!node.is_shadowarg());
    assert!(!node.is_splat());
    assert!(!node.is_str());
    assert!(!node.is_super());
    assert!(!node.is_sym());
    assert!(!node.is_true());
    assert!(!node.is_undef());
    assert!(!node.is_unless_guard());
    assert!(!node.is_until());
    assert!(!node.is_until_post());
    assert!(!node.is_when());
    assert!(!node.is_while());
    assert!(!node.is_while_post());
    assert!(!node.is_x_heredoc());
    assert!(!node.is_xstr());
    assert!(!node.is_yield());
    assert!(!node.is_z_super());
}


#[test]
fn test_debug() {
    assert_eq!(
        format!("{:?}", new_test_node()),
        "Retry(Retry { expression_l: 1...2 })"
    )
}


#[test]
fn test_partial_eq() {
    let node = new_test_node();
    let same = new_test_node();
    let other = Node::new_retry(Loc::new(100, 200));

    assert_eq!(node, same);
    assert_ne!(node, other);
}


#[test]
fn test_clone() {
    let node = new_test_node();
    assert_eq!(
        node,
        node.clone()
    );
}


#[test]
fn test_getters() {
    let node = new_test_node();
    let variant = node.into_retry();

    assert_eq!(variant.get_expression_l(), &new_loc());
}


#[test]
fn test_setters() {
    let node = new_test_node();
    let mut variant = node.into_retry();

    variant.set_expression_l(new_loc());
    assert_eq!(variant.get_expression_l(), &new_loc());
}


#[test]
fn test_into_internal() {
    let node = new_test_node();
    let variant = node.into_retry();
    let internal = variant.into_internal();

    assert_eq!(&internal.expression_l, &new_loc());
}

