// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a single `rescue` handler (i.e. `rescue E => e ...`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct RescueBody {
    /// A list of exception classes
    ///
    /// `None` if no classes specified (i.e. `rescue => e; ...` or just `rescue; ...`)
    pub exc_list: Option<Box<Node>>,

    /// Variable that captures exception
    ///
    /// `None` if no variable specified (i.e. `rescue E; ...` or just `rescue; ... `)
    pub exc_var: Option<Box<Node>>,

    /// Body of the handler
    pub body: Option<Box<Node>>,

    /// Location of the `rescue` keyword
    ///
    /// ```text
    /// begin; 1; rescue E => e; 2; end
    ///           ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `=>` operator
    ///
    /// ```text
    /// begin; 1; rescue E => e; 2; end
    ///                    ~~
    /// ```
    ///
    /// `None` if exception is not captured.
    pub assoc_l: Option<Loc>,

    /// Location of the `then` keyword
    ///
    /// ```text
    /// begin; 1; rescue E => e then; 2; end
    ///                         ~~~~
    /// ```
    ///
    /// `then` is optional, so `begin_l` can be `None`
    pub begin_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; 1; rescue E => e then; 2; end
    ///           ~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl RescueBody {
    #[doc(hidden)]
    pub fn get_exc_list(&self) -> &Option<Box<Node>> {
        &self.exc_list
    }

    #[doc(hidden)]
    pub fn get_exc_list_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.exc_list
    }

    #[doc(hidden)]
    pub fn get_exc_var(&self) -> &Option<Box<Node>> {
        &self.exc_var
    }

    #[doc(hidden)]
    pub fn get_exc_var_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.exc_var
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_assoc_l(&self) -> &Option<Loc> {
        &self.assoc_l
    }

    #[doc(hidden)]
    pub fn get_assoc_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.assoc_l
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_exc_list(&mut self, value: Option<Box<Node>>) {
        self.exc_list = value;
    }

    #[doc(hidden)]
    pub fn set_exc_var(&mut self, value: Option<Box<Node>>) {
        self.exc_var = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_assoc_l(&mut self, value: Option<Loc>) {
        self.assoc_l = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalRescueBody {
        let Self { exc_list, exc_var, body, keyword_l, assoc_l, begin_l, expression_l } = self;
        super::InternalRescueBody { exc_list, exc_var, body, keyword_l, assoc_l, begin_l, expression_l }
    }
}

impl InnerNode for RescueBody {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.exc_list);
        result.push_maybe_node_or_nil(&self.exc_var);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "resbody"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.exc_list.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.exc_var.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.assoc_l.as_ref().map(|loc| loc.print("assoc"));
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.expression_l.print("expression");
    }
}
