// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `rescue` block
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Rescue {
    /// Body of the block that is wrapped into `rescue` (i.e. the part that may throw an error)
    pub body: Option<Box<Node>>,

    /// A list of `rescue` handlers (see `RescueBody` node)
    pub rescue_bodies: Vec<Node>,

    /// Else branch.
    ///
    /// `None` if there's no `else` branch
    pub else_: Option<Box<Node>>,

    /// Location of the `else` keyword
    ///
    /// ```text
    /// begin; 1; rescue StandardError => e; 2; else; 3; end
    ///                                         ~~~~
    /// ```
    ///
    /// `None` if there's no `else` branch
    pub else_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; 1; rescue StandardError => e; 2; else; 3; end
    ///        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    ///
    /// **Note**: `begin/end` keywords belong to `KwBegin` node
    pub expression_l: Loc,
}

impl Rescue {
    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_rescue_bodies(&self) -> &Vec<Node> {
        &self.rescue_bodies
    }

    #[doc(hidden)]
    pub fn get_rescue_bodies_mut(&mut self) -> &mut Vec<Node> {
        &mut self.rescue_bodies
    }

    #[doc(hidden)]
    pub fn get_else(&self) -> &Option<Box<Node>> {
        &self.else_
    }

    #[doc(hidden)]
    pub fn get_else_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.else_
    }

    #[doc(hidden)]
    pub fn get_else_l(&self) -> &Option<Loc> {
        &self.else_l
    }

    #[doc(hidden)]
    pub fn get_else_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.else_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_rescue_bodies(&mut self, value: Vec<Node>) {
        self.rescue_bodies = value;
    }

    #[doc(hidden)]
    pub fn set_else(&mut self, value: Option<Box<Node>>) {
        self.else_ = value;
    }

    #[doc(hidden)]
    pub fn set_else_l(&mut self, value: Option<Loc>) {
        self.else_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalRescue {
        let Self { body, rescue_bodies, else_, else_l, expression_l } = self;
        super::InternalRescue { body, rescue_bodies, else_, else_l, expression_l }
    }
}

impl InnerNode for Rescue {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.body);
        result.push_nodes(&self.rescue_bodies);
        result.push_maybe_node_or_nil(&self.else_);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "rescue"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        for node in self.rescue_bodies.iter() {
          node.inner_ref().print_with_locs();
        }
        self.else_.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.else_l.as_ref().map(|loc| loc.print("else"));
        self.expression_l.print("expression");
    }
}
