// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents flags of the regex literal (i.e. `mix` for `/foo/mix`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct RegOpt {
    /// A list of flags
    pub options: Option<String>,

    /// Location of the full expression
    ///
    /// ```text
    /// /foo/mix
    ///      ~~~
    /// ```
    pub expression_l: Loc,
}

impl RegOpt {
    #[doc(hidden)]
    pub fn get_options(&self) -> &Option<String> {
        &self.options
    }

    #[doc(hidden)]
    pub fn get_options_mut(&mut self) -> &mut Option<String> {
        &mut self.options
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_options(&mut self, value: Option<String>) {
        self.options = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalRegOpt {
        let Self { options, expression_l } = self;
        super::InternalRegOpt { options, expression_l }
    }
}

impl InnerNode for RegOpt {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_chars(&self.options);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "regopt"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}
