// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a sole block argument (e.g. `|foo|`)
///
/// Block that takes a single array argument automatically expands it.
/// Adding trailing comma after block argument disables this behavior (and then the only argument is emitted as `Arg`).
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Procarg0 {
    /// Parts of the sole block argument.
    ///
    /// `proc { |(a, b)| }` also counts as a sole argument, so this list may contain:
    /// 1. A single `Arg` node (for `proc { |a| }` case)
    /// 2. Multiple `Arg` nodes  (for `proc { |(a, b, c)| }` case)
    pub args: Vec<Node>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// proc { |(foo, bar)| }
    ///         ~
    /// ```
    ///
    /// `None` if there's only one argument
    pub begin_l: Option<Loc>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// proc { |(foo, bar)| }
    ///                  ~
    /// ```
    ///
    /// `None` if there's only one argument
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// proc { |(foo, bar)| }
    ///         ~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Procarg0 {
    #[doc(hidden)]
    pub fn get_args(&self) -> &Vec<Node> {
        &self.args
    }

    #[doc(hidden)]
    pub fn get_args_mut(&mut self) -> &mut Vec<Node> {
        &mut self.args
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_args(&mut self, value: Vec<Node>) {
        self.args = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalProcarg0 {
        let Self { args, begin_l, end_l, expression_l } = self;
        super::InternalProcarg0 { args, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Procarg0 {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.args);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "procarg0"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.args.iter() {
          node.inner_ref().print_with_locs();
        }
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.expression_l.print("expression");
    }
}
