// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `BEGIN { ... }` statement
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Preexe {
    /// Body of the block
    pub body: Option<Box<Node>>,

    /// Location of the `BEGIN` keyword
    ///
    /// ```text
    /// BEGIN { 42 }
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// BEGIN { 42 }
    ///       ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// BEGIN { 42 }
    ///            ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// BEGIN { 42 }
    /// ~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Preexe {
    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalPreexe {
        let Self { body, keyword_l, begin_l, end_l, expression_l } = self;
        super::InternalPreexe { body, keyword_l, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Preexe {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node(&self.body);
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "preexe"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
