// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a pattern based on a "pinned" variable (e.g. `^foo`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Pin {
    /// Variable that is pinned
    pub var: Box<Node>,

    /// Location of the `^` operator
    ///
    /// ```text
    /// case foo; in ^bar; end
    ///              ~
    /// ```
    pub selector_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in ^bar; end
    ///              ~~~~
    /// ```
    pub expression_l: Loc,
}

impl Pin {
    #[doc(hidden)]
    pub fn get_var(&self) -> &Box<Node> {
        &self.var
    }

    #[doc(hidden)]
    pub fn get_var_mut(&mut self) -> &mut Box<Node> {
        &mut self.var
    }

    #[doc(hidden)]
    pub fn get_selector_l(&self) -> &Loc {
        &self.selector_l
    }

    #[doc(hidden)]
    pub fn get_selector_l_mut(&mut self) -> &mut Loc {
        &mut self.selector_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_var(&mut self, value: Box<Node>) {
        self.var = value;
    }

    #[doc(hidden)]
    pub fn set_selector_l(&mut self, value: Loc) {
        self.selector_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalPin {
        let Self { var, selector_l, expression_l } = self;
        super::InternalPin { var, selector_l, expression_l }
    }
}

impl InnerNode for Pin {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.var);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "pin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.var.inner_ref().print_with_locs();
        self.selector_l.print("selector");
        self.expression_l.print("expression");
    }
}
