// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a key/value pair (e.g. a part of the `Hash` node)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Pair {
    /// Key of the pair
    pub key: Box<Node>,

    /// Value of the pair
    pub value: Box<Node>,

    /// Location of the `:` or `=>` operator
    ///
    /// ```text
    /// { foo: bar }
    ///      ~
    ///
    /// { :foo => bar }
    ///        ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// { foo: bar }
    ///   ~~~~~~~~
    ///
    /// { :foo => bar }
    ///   ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Pair {
    #[doc(hidden)]
    pub fn get_key(&self) -> &Box<Node> {
        &self.key
    }

    #[doc(hidden)]
    pub fn get_key_mut(&mut self) -> &mut Box<Node> {
        &mut self.key
    }

    #[doc(hidden)]
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut Box<Node> {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_key(&mut self, value: Box<Node>) {
        self.key = value;
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalPair {
        let Self { key, value, operator_l, expression_l } = self;
        super::InternalPair { key, value, operator_l, expression_l }
    }
}

impl InnerNode for Pair {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.key);
        result.push_node(&self.value);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "pair"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.key.inner_ref().print_with_locs();
        self.value.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
