// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalPair;
use crate::blobs::{HasBlob, Blob};

/// Represents a key/value pair (e.g. a part of the `Hash` node)
#[repr(C)]
pub struct Pair {
    pub(crate) blob: Blob<Pair>
}

impl std::fmt::Debug for Pair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Pair")
            .field("key", &self.get_key())
            .field("value", &self.get_value())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Pair {
    fn eq(&self, other: &Self) -> bool {
        self.get_key() == other.get_key()
            && self.get_value() == other.get_value()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Pair {
    /// Returns `key` field
    pub fn get_key(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__pair__get_key(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `key` field
    pub fn set_key(&mut self, key: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__pair__set_key(&mut self.blob, key.into_blob()) }
    }

    /// Returns `value` field
    pub fn get_value(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__pair__get_value(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__pair__set_value(&mut self.blob, value.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__pair__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__pair__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__pair__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__pair__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalPair {
        unsafe { lib_ruby_parser__external__nodes__pair__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__pair__get_key(blob: *const Blob<Pair>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__pair__set_key(blob: *mut Blob<Pair>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__pair__get_value(blob: *const Blob<Pair>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__pair__set_value(blob: *mut Blob<Pair>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__pair__get_operator_l(blob: *const Blob<Pair>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__pair__set_operator_l(blob: *mut Blob<Pair>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__pair__get_expression_l(blob: *const Blob<Pair>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__pair__set_expression_l(blob: *mut Blob<Pair>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__pair__into_internal(blob: Blob<Pair>) -> InternalPair;
    fn lib_ruby_parser__external__nodes__pair__drop(blob: *mut Blob<Pair>);
}

impl InnerNode for Pair {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_key());
        result.push_node(self.get_value());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "pair"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_key().inner_ref().print_with_locs();
        self.get_value().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Pair {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__pair__drop(&mut self.blob) }
    }
}
