// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a block that takes numbered parameters (i.e. `proc { _1 }`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Numblock {
    /// Method call that takes a block
    pub call: Box<Node>,

    /// Number of parameters that block takes
    pub numargs: u8,

    /// Block body
    pub body: Box<Node>,

    /// Location of the open brace
    ///
    /// ```text
    /// proc { _1 }
    ///      ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing brace
    ///
    /// ```text
    /// proc { _1 }
    ///           ~
    /// ```
    pub end_l: Loc,

    /// Location of the open brace
    ///
    /// ```text
    /// proc { _1 }
    /// ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Numblock {
    #[doc(hidden)]
    pub fn get_call(&self) -> &Box<Node> {
        &self.call
    }

    #[doc(hidden)]
    pub fn get_call_mut(&mut self) -> &mut Box<Node> {
        &mut self.call
    }

    #[doc(hidden)]
    pub fn get_numargs(&self) -> &u8 {
        &self.numargs
    }

    #[doc(hidden)]
    pub fn get_numargs_mut(&mut self) -> &mut u8 {
        &mut self.numargs
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Box<Node> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Box<Node> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_call(&mut self, value: Box<Node>) {
        self.call = value;
    }

    #[doc(hidden)]
    pub fn set_numargs(&mut self, value: u8) {
        self.numargs = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Box<Node>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalNumblock {
        let Self { call, numargs, body, begin_l, end_l, expression_l } = self;
        super::InternalNumblock { call, numargs, body, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Numblock {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.call);
        result.push_u8(&self.numargs);
        result.push_node(&self.body);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "numblock"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.call.inner_ref().print_with_locs();
        self.body.inner_ref().print_with_locs();
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
